<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText, li.MsoBodyText, div.MsoBodyText
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.CorpsdetexteCar
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">C1OPEREQUIP</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><xsl:variable name="eltsBoucleEtat" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:InfoOpe/@V='DETAIL')]/n:Operation/@V"/><xsl:choose>
               <xsl:when test="count($eltsBoucleEtat)=0">
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="87.4%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                           </td>
                           <td width="12.6%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="87.4%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">OPERATIONS D’EQUIPEMENT – DETAIL DES CHAPITRES ET ARTICLES</span></b></p>
                              
                           </td>
                           <td width="12.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">C1</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template><br/><p class="normalText">Cet état ne contient pas d'information.</p>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:for-each select="$eltsBoucleEtat">
                     <xsl:sort select="."/>
                     <xsl:variable name="codeBoucleEtat" select="."/>
                     <xsl:if test="position() &gt; 1">
                        <div style="page-break-before : always;"/>
                     </xsl:if><xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:Operation/@V=$codeBoucleEtat)]"/>
                     
                     
                     <div class="WordSection1">
                        
                        <div align="center">
                           
                           <xsl:variable name="varOdmTmpTab2">
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                                 <tr>
                                    <td width="87.4%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                                       
                                    </td>
                                    <td width="12.6%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II</span></b></p>
                                       
                                    </td>
                                 </tr>
                                 <tr>
                                    <td width="87.4%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">OPERATIONS D’EQUIPEMENT – DETAIL DES CHAPITRES ET ARTICLES</span></b></p>
                                       
                                    </td>
                                    <td width="12.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">C1</span></b></p>
                                       
                                    </td>
                                 </tr>
                              </table>
                           </xsl:variable>
                           <xsl:call-template name="table:outputTable">
                              <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                           </xsl:call-template>
                           
                        </div>
                        
                        <p class="MsoNormal" style="margin-top:0in;margin-right:39.4pt;margin-bottom: 0in;margin-left:14.2pt;margin-bottom:.0001pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <p class="MsoNormal" style="margin-top:0in;margin-right:39.4pt;margin-bottom: 0in;margin-left:14.2pt;margin-bottom:.0001pt"><b><span style="font-family:&quot;Arial&quot;,sans-serif">OPERATIONS D’EQUIPEMENT N° : <xsl:value-of select="distinct-values($codeBoucleEtat)"/>(1)</span></b></p>
                        
                        <p class="MsoNormal" style="margin-top:0in;margin-right:39.4pt;margin-bottom: 0in;margin-left:14.2pt;margin-bottom:.0001pt"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">LIBELLE : <xsl:value-of select="distinct-values($varOdm1/n:LibCpte/@V)"/></span></b></p>
                        
                        <p class="MsoNormal" style="margin-top:0in;margin-right:39.4pt;margin-bottom: 0in;margin-left:14.2pt;margin-bottom:.0001pt"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <p class="MsoNormal" style="margin-top:0in;margin-right:39.4pt;margin-bottom: 0in;margin-left:14.2pt;margin-bottom:.0001pt"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <div align="center">
                           
                           <xsl:variable name="varOdmTmpTab3">
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm2" select="$varOdm1[(./n:CodRD/@V='D') and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0')]"/>
                                 <thead>
                                    
                                    <tr height="0" class="#tech# #fixWidths#">
                                       <td width="10.1%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="27.3%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="12%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="6.3%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="6.3%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="12.7%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="12.7%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="4.1%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="8.4%" style="border:none" rowspan="1" colspan="1"/>
                                    </tr>
                                    
                                    <tr style="page-break-inside:avoid">
                                       <td width="10.1%" valign="top" style="border:none;border-bottom:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                       <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                       <td width="50%" colspan="5" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Eléments afférents à l’exercice</span></b></p>
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                                          
                                       </td>
                                       <td width="12.4%" colspan="2" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Pour mémoire</span></b></p>
                                          
                                       </td>
                                    </tr>
                                    
                                    <tr style="page-break-inside:avoid">
                                       <td width="10.1%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Chap./ art. (2)</span></b></p>
                                          
                                       </td>
                                       <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Libellé</span></b></p>
                                          
                                       </td>
                                       <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Prévisions (a)</span></b></p>
                                          
                                       </td>
                                       <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Réalisations</span></b></p>
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Mandats émis (b)</span></b></p>
                                          
                                       </td>
                                       <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                          
                                       </td>
                                       <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Restes à réaliser au 31/12 (3)</span></b></p>
                                          
                                       </td>
                                       <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Cumul des réalisations (4)</span></b></p>
                                          
                                       </td>
                                    </tr>
                                    
                                 </thead>
                                 <tr style="page-break-inside:avoid">
                                    <td width="37.4%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">DEPENSES</span></b></p>
                                       
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="6.3%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">A</span></b></p>
                                       
                                    </td>
                                    <td width="6.3%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="4.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">B</span></b></p>
                                       
                                    </td>
                                    <td width="8.4%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm3" select="$varOdm2[(n:ChapitreNature/@V='20')]"/>
                                    <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 20</span></b></p>
                                       
                                    </td>
                                    <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"/> (sauf 204)</span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm4">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='20' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm5">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm4/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.3%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm4"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm5/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm6" select="$varOdm2[(n:ChapitreNature/@V='204')]"/>
                                    <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 204</span></b></p>
                                       
                                    </td>
                                    <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm7">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='204' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm8">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm7/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.3%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm7"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm8/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm9" select="$varOdm2[(n:ChapitreNature/@V='21')]"/>
                                    <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 21</span></b></p>
                                       
                                    </td>
                                    <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm10">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='21' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm11">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm10/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.3%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm10"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm11/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm12" select="$varOdm2[(n:ChapitreNature/@V='22')]"/>
                                    <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 22</span></b></p>
                                       
                                    </td>
                                    <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm13">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='22' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm14">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm13/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.3%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm13"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm14/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm15" select="$varOdm2[(n:ChapitreNature/@V='23')]"/>
                                    <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 23</span></b></p>
                                       
                                    </td>
                                    <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm15/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm15/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm15/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm16">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='23' and @CodRD='D' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10.1%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm17">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm16/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.3%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm16"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm17/xhtml:tr"/>
                                 </xsl:call-template>
                              </table>
                           </xsl:variable>
                           <xsl:call-template name="table:outputTable">
                              <xsl:with-param name="table" select="$varOdmTmpTab3"/>
                           </xsl:call-template>
                           
                        </div>
                        
                        <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p><b/><p class="MsoNormal" align="left" style="margin-bottom:10.0pt;text-align:left; line-height:115%;page-break-before:always"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <div align="center">
                           
                           <xsl:variable name="varOdmTmpTab4">
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm18" select="$varOdm1[(./n:CodRD/@V='R') and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0')]"/>
                                 <thead>
                                    
                                    <tr height="0" class="#tech# #fixWidths#">
                                       <td width="10%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="27.4%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="12%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="6.2%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="6.5%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="12.7%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="12.7%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="4%" style="border:none" rowspan="1" colspan="1"/>
                                       <td width="8.5%" style="border:none" rowspan="1" colspan="1"/>
                                    </tr>
                                    
                                    <tr style="page-break-inside:avoid">
                                       <td width="10%" valign="top" style="border:none;border-bottom:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                       <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                       <td width="50.1%" colspan="5" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Eléments afférents à l’exercice</span></b></p>
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                                          
                                       </td>
                                       <td width="12.4%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Pour mémoire</span></b></p>
                                          
                                       </td>
                                    </tr>
                                    
                                    <tr style="page-break-inside:avoid">
                                       <td width="10%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Recettes (répartition)</span></b></p>
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">(pour information)</span></b></p>
                                          
                                       </td>
                                       <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Libellé</span></b></p>
                                          
                                       </td>
                                       <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Prévisions (a)</span></b></p>
                                          
                                       </td>
                                       <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Réalisations</span></b></p>
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Titres émis (b)</span></b></p>
                                          
                                       </td>
                                       <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                          
                                       </td>
                                       <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                          
                                          <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Restes à réaliser au 31/12 (3)</span></b></p>
                                          
                                       </td>
                                       <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Cumul des réalisations (4)</span></b></p>
                                          
                                       </td>
                                    </tr>
                                    
                                 </thead>
                                 <tr style="page-break-inside:avoid">
                                    <td width="37.4%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">TOTAL RECETTES AFFECTEES (5)</span></b></p>
                                       
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="6.2%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">C</span></b></p>
                                       
                                    </td>
                                    <td width="6.5%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="4%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">D</span></b></p>
                                       
                                    </td>
                                    <td width="8.5%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <tr style="page-break-inside:avoid">
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 13</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"/> (reçues) (sauf le 138)</span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECREL13H138DETAIL')]/n:CredOuv/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECREL13H138DETAIL')]/n:MtReal/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"/></b><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECREL13H138DETAIL')]/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECREL13H138DETAIL')]/n:MtSup[(@Code='MtOpeCumul')]/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm19">
                                    <xsl:for-each select="$nomenclature/n:GroupeDetail/n:Compte[@Type='C' and @Code='GRECREL13H138DETAIL']/descendant::node()[@Type = 'A']/@Code">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm20">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm19/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm19"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm20/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid">
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 16</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"/> (6)</span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GREC16EQPTDETAIL')]/n:CredOuv/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GREC16EQPTDETAIL')]/n:MtReal/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"/></b><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GREC16EQPTDETAIL')]/n:MtRAR3112/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GREC16EQPTDETAIL')]/n:MtSup[(@Code='MtOpeCumul')]/@V"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm21">
                                    <xsl:for-each select="$nomenclature/n:GroupeDetail/n:Compte[@Type='C' and @Code='GREC16EQPTDETAIL']/descendant::node()[@Type = 'A']/@Code">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm22">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm21/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm21"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm22/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm23" select="$varOdm18[(n:ChapitreNature/@V='20')]"/>
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 20</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"/> (sauf 204)</span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm23/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm23/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm23/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm23/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm24">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='20' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm25">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm24/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm24"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm25/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm26" select="$varOdm18[(n:ChapitreNature/@V='204')]"/>
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 204</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm26/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm26/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm26/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm26/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm27">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='204' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span style="font-size:7.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm28">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm27/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm27"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm28/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm29" select="$varOdm18[(n:ChapitreNature/@V='21')]"/>
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 21</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm29/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm29/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm29/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm29/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm30">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='21' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm31">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm30/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm30"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm31/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm32" select="$varOdm18[(n:ChapitreNature/@V='22')]"/>
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 22</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm32/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm32/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm32/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm32/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm33">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='22' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm34">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm33/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm33"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm34/xhtml:tr"/>
                                 </xsl:call-template>
                                 <tr style="page-break-inside:avoid"><xsl:variable name="varOdm35" select="$varOdm18[(n:ChapitreNature/@V='23')]"/>
                                    <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif">Total chapitre 23</span></b></p>
                                       
                                    </td>
                                    <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"/></span></b></p>
                                    </td>
                                    <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm35/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm35/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm35/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm35/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                                 <xsl:variable name="varOdm36">
                                    <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='23' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                                       <xsl:sort select="."/>
                                       <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$varOdm18[(./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"/>
                                       <xsl:if test="$ligne">
                                          <tr style="page-break-inside:avoid">
                                             <td width="10%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                             </td>
                                             <td width="27.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"/></span></p>
                                             </td>
                                             <td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                             <td width="12.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                                <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                                             </td>
                                          </tr>
                                       </xsl:if>
                                    </xsl:for-each>
                                 </xsl:variable>
                                 <xsl:variable name="varOdm37">
                                    <xsl:choose>
                                       <xsl:when test="count($varOdm36/*) = 0">
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             <td height="1px" width="10%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="27.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt"/>
                                             <td height="1px" width="12.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt"/>
                                          </tr>
                                       </xsl:when>
                                       <xsl:otherwise>
                                          <xsl:sequence select="$varOdm36"/>
                                       </xsl:otherwise>
                                    </xsl:choose>
                                 </xsl:variable>
                                 <xsl:call-template name="table:processRowBorders">
                                    <xsl:with-param name="borderStyle" select="'none'"/>
                                    <xsl:with-param name="rows" select="$varOdm37/xhtml:tr"/>
                                 </xsl:call-template>
                              </table>
                           </xsl:variable>
                           <xsl:call-template name="table:outputTable">
                              <xsl:with-param name="table" select="$varOdmTmpTab4"/>
                           </xsl:call-template>
                           
                        </div>
                        
                        <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <div align="center">
                           
                           <xsl:variable name="varOdmTmpTab5">
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                                 <tr height="0" class="#tech# #fixWidths#">
                                    <td width="43.5%" style="border:none" rowspan="1" colspan="1"/>
                                    <td width="8.3%" style="border:none" rowspan="1" colspan="1"/>
                                    <td width="20%" style="border:none" rowspan="1" colspan="1"/>
                                    <td width="8.3%" style="border:none" rowspan="1" colspan="1"/>
                                    <td width="20%" style="border:none" rowspan="1" colspan="1"/>
                                 </tr>
                                 <tr>
                                    <td width="43.5%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="margin-right:2.55pt;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Solde du financement (7)</span></b></p>
                                       
                                    </td>
                                    <td width="20%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       
                                       <p class="MsoHeader" style="margin-right:2.55pt;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Pour l’exercice</span></b></p>
                                       
                                    </td>
                                    <td width="20%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                                       
                                       <p class="MsoHeader" style="margin-right:2.55pt;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">En cumulé</span></b></p>
                                       
                                    </td>
                                 </tr>
                                 <tr><xsl:variable name="varOdm38" select="$varOdm1[(n:Groupe/@V='SOLDEINVOP')]"/>
                                    <td width="43.5%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoNormal" style="margin-right:2.55pt;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Recettes – Dépenses</span></b></p>
                                       
                                    </td>
                                    <td width="8.3%" valign="top" style="border:none;border-bottom:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoHeader" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif">C - A</span></b></p>
                                       
                                    </td>
                                    <td width="20%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm38/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                    <td width="8.3%" valign="top" style="border:none;border-bottom:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       
                                       <p class="MsoHeader" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif">D - B</span></b></p>
                                       
                                    </td>
                                    <td width="20%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                       <p class="MsoHeader" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm38/n:MtSup[(@Code='MtOpeCumul')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                                    </td>
                                 </tr>
                              </table>
                           </xsl:variable>
                           <xsl:call-template name="table:outputTable">
                              <xsl:with-param name="table" select="$varOdmTmpTab5"/>
                           </xsl:call-template>
                           
                        </div>
                        
                        <p class="MsoNormal"><b><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <p class="MsoNormal"><b><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) Ouvrir une page par chapitre d’opération.</span></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(2) Détailler les articles utilisés conformément au plan de comptes.</span></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(3) Dépenses engagées non mandatées ou recettes justifiées non titrées.</span></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(4) Réalisations antérieures + réalisations de l’exercice.</span></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(5) Exceptionnellement, les comptes 20, 204, 21, 22 et 23 sont en recettes réelles en cas de réduction ou d’annulation de
                              mandats donnant lieu à reversement.</span></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(6) Sauf 165, 166 et 16449.</span></p>
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(7) Indiquer le signe algébrique.</span></p>
                        
                     </div>
                     
                  </xsl:for-each>
               </xsl:otherwise>
            </xsl:choose></body></html>
   </xsl:template></xsl:stylesheet>